/*
 * Decompiled with CFR 0.152.
 */
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import oracle.ewt.grid.Cell;
import oracle.ewt.grid.CellInputHandler;
import oracle.ewt.grid.Grid;
import oracle.ewt.lwAWT.lwText.LWPasswordField;
import oracle.ewt.painter.BorderPainter;
import oracle.ewt.painter.FixedBorderPainter;
import oracle.ewt.util.InputEventUtils;

public class PasswordFieldInputHandler
extends CellInputHandler {
    boolean _dirty;
    private static PasswordFieldInputHandler _sInputHandler;
    private LWPasswordField _passwordField;

    public LWPasswordField getLWPasswordField() {
        return (LWPasswordField)this.getEditControl(null, -1, -1);
    }

    public void focusGained(AWTEvent why, Grid grid, int column, int row) {
        grid.startCellEdit(column, row);
    }

    public void mousePressed(MouseEvent e, Grid grid, int column, int row) {
        Cell focusCell = grid.getFocusCell();
        if (focusCell.column == column && focusCell.row == row && InputEventUtils.isLeftMouseButton((MouseEvent)e)) {
            grid.startCellEdit(column, row);
        }
        super.mousePressed(e, grid, column, row);
    }

    public void keyTyped(KeyEvent e, Grid grid, int column, int row) {
        if (e.getKeyChar() == '\t' || e.getKeyChar() == '\u001b' || e.getKeyChar() == '\n' || e.getKeyChar() == '\r') {
            return;
        }
        grid.startCellEdit(column, row);
        LWPasswordField control = this.getLWPasswordField();
        if (control.isEditable()) {
            if (e.getKeyChar() == '\b') {
                control.setText("");
                this._dirty = true;
            } else {
                String valueText = String.valueOf(e.getKeyChar());
                control.setText(valueText);
                control.select(1, 1);
                this._dirty = true;
            }
        }
        e.consume();
    }

    public synchronized Component getEditControl(Grid grid, int column, int row) {
        if (this._passwordField == null) {
            this._passwordField = new LWPasswordField();
            this._passwordField.addTextListener((TextListener)new Dirty());
            this._passwordField.setBorderPainter((BorderPainter)new FixedBorderPainter(0, 2, 0, 0));
        }
        return this._passwordField;
    }

    public boolean isDirty(Grid grid, int column, int row) {
        return this._dirty;
    }

    public void startEdit(Grid grid, int column, int row, Object data) {
        LWPasswordField field = this.getLWPasswordField();
        field.setText((String)data);
        field.selectAll();
        this._dirty = false;
    }

    public synchronized Object commitEdit(Grid grid, int column, int row) {
        LWPasswordField edit = this.getLWPasswordField();
        String data = edit.getText();
        return data;
    }

    public static CellInputHandler getCellInputHandler() {
        if (_sInputHandler == null) {
            _sInputHandler = PasswordFieldInputHandler.createPasswordFieldInputHandler();
        }
        return _sInputHandler;
    }

    public static PasswordFieldInputHandler createPasswordFieldInputHandler() {
        return new PasswordFieldInputHandler();
    }

    private class Dirty
    implements TextListener {
        private Dirty() {
        }

        @Override
        public void textValueChanged(TextEvent e) {
            PasswordFieldInputHandler.this._dirty = true;
        }
    }
}

